
`timescale 1ns / 100ps

module b_left_shifter2 (
	shift_in,
	shift_value,
	shift_out
);

parameter fsize = 52;

input [fsize*2+1:0] shift_in;
input [6:0] shift_value;
output [fsize*2+1:0] shift_out;

assign shift_out = shift_in << shift_value;

endmodule 

module b_right_shifter2 (
	shift_in,
	shift_value,
	shift_out
);
parameter fsize = 52;

input [fsize*2+1:0] shift_in;
input [6:0] shift_value;
output [fsize*2+1:0] shift_out;


assign shift_out = shift_in >> shift_value;

endmodule 


module b_right_shifter2a (
	shift_in,
	shift_value,
	shift_out
);
parameter fsize = 52;

input [fsize+3:0] shift_in;
input [5:0] shift_value;
output [fsize+3:0] shift_out;

assign shift_out = shift_in >> shift_value;

endmodule 
