-- VHDL floating point sub wrapper
-- author: Ho Chun Hok
-- cho@doc.ic.ac.uk
-- must compile with -93 syntax


library ieee;

use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;

-- entity declaration
entity fpsub2 is
port ( 
      CLK : in std_logic ;
      FA  : in std_logic_vector( 63 downto 0);
      FB  : in std_logic_vector( 63 downto 0);
      Q   : out std_logic_vector( 63 downto 0);
	  start: in boolean;
	  finish: out boolean 
     );

end fpsub2;

-- end entity declaration
-- architecture block

architecture RTL of fpsub2 is

component fpu2_sub
	port (
		clk : in std_logic;
		rmode : in std_logic_vector( 1 downto 0);
		opa : in std_logic_vector ( 63 downto 0);
		opb : in std_logic_vector ( 63 downto 0);
		outr : out std_logic_vector ( 63 downto 0);
		inf : out std_logic;
		snan : out std_logic;
		qnan : out std_logic;
		ine : out std_logic;
		underflow : out std_logic;
		overflow : out std_logic;
		zero : out std_logic;
		div_by_zero : out std_logic
	);
end component fpu2_sub;

signal s1, s2, s3, s4, s5 : boolean;
signal rmode : std_logic_vector (1 downto 0);

begin

rmode <= "00";
p0: process (clk)
begin
	if (clk = '1' and clk'event) then
		s1 <= start;
		s2 <= s1;
		s3 <= s2;
		s4 <= s3;
		finish <= s4;
	end if;
end process;

u0: fpu2_sub	port map
(
	clk => clk,
	rmode => rmode,
	opa => FA,
	opb => FB,
	outr => Q,
	inf => open,
	snan => open,
	qnan => open,
	ine => open,
	underflow => open,
	overflow => open,
	zero => open,
	div_by_zero =>open
);



end RTL;


